---
type: axiom
tags:
  - "#layer/translation"
  - "#status/stable"
  - "#function/definition"
polarity: P-  # Void-oriented; deals with field directionality
aliases:
  - Asymmetry
---

# A2 — Asymmetry (axiom)

> Order matters: ∆(A,B) ≠ ∆(B,A) in any meaningful embedding.

---

## Statement

- Difference is inherently directional: the relationship between A and B depends on which is considered the reference point.

---

## Dual‑register mapping

Map the axiom into both registers and show the bridge explicitly.

### Technical (network/computational)

| Axiom concept | Network construct (Target) | Interface/API example |
|---------------|---------------------------|----------------------|
| Directionality | Directed graph | `DirectedGraph` |
| Propagation | Message flow | `MessageRouter` |
| Field gradient | Potential difference | `GradientField` |

### Humane (biological/relational)

| Axiom concept | Humane construct (Target) | Example |
|---------------|---------------------------|---------|
| Directionality | Felt difference | Loving vs being loved feels different |
| Propagation | Emotional resonance | Joy spreads differently than sadness |
| Field gradient | Intuitive pull | Being drawn toward or away from something |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Directed edge | Felt connection | One-way vs mutual experience |
| Message path | Emotional field | How feelings move between people |
| Field potential | Heart's pull | Natural direction of care/attention |

---

## Domain Mapping

Brief consequences across domains, showing both technical and humane angles:

| Domain | Technical manifestation | Humane manifestation |
|--------|------------------------|---------------------|
| Physics | Signal causality | Time's arrow |
| Chemistry | Reaction direction | Catalytic preference |
| Biology | Gene expression | Developmental bias |
| Social | Network flow | Influence direction |
| Economy | Market vectors | Value perception |
| Politics | Power gradients | Authority flow |
| Networks | Directed edges | Information flow |
| Cognition | Neural weights | Attention bias |

---

## Register note (if governance)

- This is a kernel axiom (not governance). For governance principles, see [PRINCIPLES.md](../../../../../PRINCIPLES.md).

---

## Rationale (context)

- Establishes directionality in difference propagation
- Enables meaningful distinction between source and target
- Creates basis for field gradients and propagation limits

---

## Dependencies & scope

- Independent of: other axioms
- Applies to: all difference embeddings and propagation paths

---

## Implications / derivations (selected)

- Directionality: differences have inherent flow direction
- Propagation: differences move through field at bounded speed (c)
- Bias: asymmetric stabilization ratios emerge (φ)
- Field: enables gradient-based propagation (∇S)

---

## Related structures

- Primitives: [[Delta]] · [[RelationalEmbedding]] · [[Form]]
- Constants: [[φ — Asymmetric Stabilization Ratio (constant)]] · [[c — Difference Propagation Limit (constant)]]
- Modulators: λV (void resonance) depends on directional flow

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included

---

## See Also

- [[00.0.0.0 - Core Axioms (index)]]
- [[A1 — Irreducibility (axiom)]]
- [[A3 — Recursivity (axiom)]]